/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class MorgueBurstEffect
extends OneShotEffect {
    MorgueBurstEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Return target creature card from your graveyard to your hand. {this} deals damage to any target equal to the power of the card returned this way";
    }

    private MorgueBurstEffect(MorgueBurstEffect effect) {
        super((OneShotEffect)effect);
    }

    public MorgueBurstEffect copy() {
        return new MorgueBurstEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Card card = game.getCard(source.getFirstTarget());
        if (card != null && (player = game.getPlayer(card.getOwnerId())) != null) {
            player.moveCards(card, Zone.HAND, source, game);
            int damage = card.getPower().getValue();
            Permanent creature = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
            if (creature != null) {
                creature.damage(damage, source.getSourceId(), source, game, false, true);
                return true;
            }
            Player targetPlayer = game.getPlayer(((Target)source.getTargets().get(1)).getFirstTarget());
            if (targetPlayer != null) {
                targetPlayer.damage(damage, source.getSourceId(), source, game);
                return true;
            }
        }
        return false;
    }
}

