/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetEnchantmentPermanent;

class MortalObstinacyAbility
extends TriggeredAbilityImpl {
    public MortalObstinacyAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DoIfCostPaid((Effect)new DestroyTargetEffect(), (Cost)new SacrificeSourceCost()));
        this.addTarget((Target)new TargetEnchantmentPermanent());
        this.setTriggerPhrase("Whenever enchanted creature deals combat damage to a player, ");
    }

    private MortalObstinacyAbility(MortalObstinacyAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MortalObstinacyAbility copy() {
        return new MortalObstinacyAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        DamagedPlayerEvent damageEvent = (DamagedPlayerEvent)event;
        Permanent damageMakingCreature = game.getPermanent(event.getSourceId());
        return damageEvent.isCombatDamage() && damageMakingCreature != null && damageMakingCreature.getAttachments().contains(this.getSourceId());
    }
}

