/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class MossbridgeTrollCost
extends CostImpl {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("any number of untapped creatures other than {this} with total power 10 or greater");

    public MossbridgeTrollCost() {
        this.addTarget((Target)new TargetControlledPermanent(0, Integer.MAX_VALUE, (FilterControlledPermanent)filter, true));
        this.text = "tap any number of untapped creatures you control other than {this} with total power 10 or greater";
    }

    private MossbridgeTrollCost(MossbridgeTrollCost cost) {
        super((CostImpl)cost);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        int sumPower = 0;
        if (this.getTargets().choose(Outcome.Tap, controllerId, source.getSourceId(), source, game)) {
            for (UUID targetId : ((Target)this.getTargets().get(0)).getTargets()) {
                Permanent permanent = game.getPermanent(targetId);
                if (permanent == null || !permanent.tap(source, game)) continue;
                sumPower += permanent.getPower().getValue();
            }
        }
        game.informPlayers("Tap creatures with total power of " + sumPower);
        this.paid = sumPower >= 10;
        return this.paid;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        int sumPower = 0;
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, controllerId, game)) {
            if (permanent.getId().equals(source.getSourceId())) continue;
            sumPower += permanent.getPower().getValue();
        }
        return sumPower >= 10;
    }

    public MossbridgeTrollCost copy() {
        return new MossbridgeTrollCost(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        filter.add((Predicate)TappedPredicate.UNTAPPED);
    }
}

