/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class MossbridgeTrollReplacementEffect
extends ReplacementEffectImpl {
    MossbridgeTrollReplacementEffect() {
        super(Duration.Custom, Outcome.Regenerate);
        this.staticText = "If {this} would be destroyed, regenerate it";
    }

    private MossbridgeTrollReplacementEffect(MossbridgeTrollReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent mossbridgeTroll = game.getPermanent(event.getTargetId());
        if (mossbridgeTroll != null && event.getAmount() == 0) {
            return mossbridgeTroll.regenerate(source, game);
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DESTROY_PERMANENT;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId() != null && event.getTargetId().equals(source.getSourceId());
    }

    public MossbridgeTrollReplacementEffect copy() {
        return new MossbridgeTrollReplacementEffect(this);
    }
}

