/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class MotivatedPonyWatcher
extends Watcher {
    private final Set<UUID> players = new HashSet<UUID>();

    MotivatedPonyWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD && ((EntersTheBattlefieldEvent)event).getTarget().hasSubtype(SubType.FOOD, game)) {
            this.players.add(event.getPlayerId());
        }
    }

    public void reset() {
        super.reset();
        this.players.clear();
    }

    public boolean checkPlayer(UUID playerId) {
        return this.players.contains(playerId);
    }
}

