/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Objects;
import mage.MageItem;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyAllEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

class MountDoomEffect
extends OneShotEffect {
    MountDoomEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose up to two creatures, then destroy the rest";
    }

    private MountDoomEffect(MountDoomEffect effect) {
        super((OneShotEffect)effect);
    }

    public MountDoomEffect copy() {
        return new MountDoomEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCreaturePermanent target = new TargetCreaturePermanent(0, 2);
        target.withNotTarget(true);
        target.withChooseHint("the rest will be destroyed");
        player.choose(this.outcome, (Target)target, source, game);
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        target.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).map(MageItem::getId).map(PermanentIdPredicate::new).map(Predicates::not).forEach(arg_0 -> ((FilterPermanent)filter).add(arg_0));
        return new DestroyAllEffect((FilterPermanent)filter).apply(game, source);
    }
}

