/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;

class MountVelusManticoreEffect
extends OneShotEffect {
    MountVelusManticoreEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may discard a card. When you do, {this} deals X damage to any target, where X is the number of card types the discarded card has";
    }

    private MountVelusManticoreEffect(MountVelusManticoreEffect effect) {
        super((OneShotEffect)effect);
    }

    public MountVelusManticoreEffect copy() {
        return new MountVelusManticoreEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.discard(0, 1, false, source, game).getRandom(game);
        if (card == null) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(card.getCardType(game).size()), false, "{this} deals X damage to any target, where X is the number of card types the discarded card has");
        ability.addTarget((Target)new TargetAnyTarget());
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

