/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.cards.m.MultanisPresenceWatcher;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

class MultanisPresenceTriggeredAbility
extends TriggeredAbilityImpl {
    public MultanisPresenceTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1), false);
        this.setTriggerPhrase("Whenever a spell you've cast is countered, ");
    }

    private MultanisPresenceTriggeredAbility(MultanisPresenceTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MultanisPresenceTriggeredAbility copy() {
        return new MultanisPresenceTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        MultanisPresenceWatcher watcher = (MultanisPresenceWatcher)game.getState().getWatcher(MultanisPresenceWatcher.class);
        return watcher != null && watcher.getSpellsCastThisTurn(this.controllerId).contains(event.getTargetId());
    }
}

