/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Elemental44Token;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPlayer;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.util.CardUtil;

class MultipleChoiceEffect
extends OneShotEffect {
    MultipleChoiceEffect() {
        super(Outcome.Benefit);
        this.staticText = "If X is 1, scry 1, then draw a card.<br>If X is 2, you may choose a player. They return a creature they control to its owner's hand.<br>If X is 3, create a 4/4 blue and red Elemental creature token.<br>If X is 4 or more, do all of the above.";
    }

    private MultipleChoiceEffect(MultipleChoiceEffect effect) {
        super((OneShotEffect)effect);
    }

    public MultipleChoiceEffect copy() {
        return new MultipleChoiceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (xValue == 1 || xValue >= 4) {
            controller.scry(1, source, game);
            controller.drawCards(1, source, game);
        }
        if (xValue == 3 || xValue >= 4) {
            new Elemental44Token().putOntoBattlefield(1, game, source, source.getControllerId());
        }
        if (xValue != 2 && xValue < 4) {
            return true;
        }
        TargetPlayer targetPlayer = new TargetPlayer(0, 1, true);
        controller.choose(Outcome.Detriment, (Target)targetPlayer, source, game);
        Player player = game.getPlayer(targetPlayer.getFirstTarget());
        if (player == null || game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, player.getId(), source, game) <= 0) {
            return true;
        }
        TargetControlledCreaturePermanent targetPermanent = new TargetControlledCreaturePermanent();
        targetPermanent.withNotTarget(true);
        player.choose(Outcome.ReturnToHand, (Target)targetPermanent, source, game);
        Permanent permanent = game.getPermanent(targetPermanent.getFirstTarget());
        return permanent == null || player.moveCards((Card)permanent, Zone.HAND, source, game);
    }
}

