/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.cards.m.MusicianTriggeredAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MusicianEffect
extends OneShotEffect {
    MusicianEffect() {
        super(Outcome.Benefit);
        this.staticText = "If it doesn't have \"At the beginning of your upkeep, destroy this creature unless you pay {1} for each music counter on it,\" it gains that ability";
    }

    private MusicianEffect(MusicianEffect effect) {
        super((OneShotEffect)effect);
    }

    public MusicianEffect copy() {
        return new MusicianEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        if (permanent.getAbilities().stream().anyMatch(MusicianTriggeredAbility.class::isInstance)) {
            return true;
        }
        game.addEffect((ContinuousEffect)new GainAbilityTargetEffect((Ability)new MusicianTriggeredAbility(), Duration.WhileOnBattlefield), source);
        return true;
    }
}

