/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.PreventAllDamageToAllEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.effects.common.counter.ProliferateEffect;
import mage.abilities.keyword.HexproofAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.CounterAnyPredicate;

public final class MutationalAdvantage
extends CardImpl {
    private static final FilterPermanent filter = new FilterControlledPermanent("permanents you control with counters on them");

    public MutationalAdvantage(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{1}{G}{U}");
        this.getSpellAbility().addEffect((Effect)new GainAbilityControlledEffect((Ability)HexproofAbility.getInstance(), Duration.EndOfTurn, filter).setText("Permanents you control with counters on them gain hexproof"));
        this.getSpellAbility().addEffect((Effect)new GainAbilityControlledEffect((Ability)IndestructibleAbility.getInstance(), Duration.EndOfTurn, filter).setText("and indestructible until end of turn"));
        this.getSpellAbility().addEffect((Effect)new PreventAllDamageToAllEffect(Duration.EndOfTurn, filter).setText("Prevent all damage that would be dealt to those permanents this turn"));
        this.getSpellAbility().addEffect((Effect)new ProliferateEffect());
    }

    private MutationalAdvantage(MutationalAdvantage card) {
        super((CardImpl)card);
    }

    public MutationalAdvantage copy() {
        return new MutationalAdvantage(this);
    }

    static {
        filter.add((Predicate)CounterAnyPredicate.instance);
    }
}

