/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValueParityPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MutinousMassacreEffect
extends OneShotEffect {
    private static final FilterPermanent evenFilter = new FilterCreaturePermanent();
    private static final FilterPermanent oddFilter = new FilterCreaturePermanent();

    MutinousMassacreEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose odd or even. Destroy each creature with mana value of the chosen quality";
    }

    private MutinousMassacreEffect(MutinousMassacreEffect effect) {
        super((OneShotEffect)effect);
    }

    public MutinousMassacreEffect copy() {
        return new MutinousMassacreEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        FilterPermanent filter = player.chooseUse(this.outcome, "Odd or even?", null, "Odd", "Even", source, game) ? oddFilter : evenFilter;
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            permanent.destroy(source, game);
        }
        return true;
    }

    static {
        evenFilter.add((Predicate)ManaValueParityPredicate.EVEN);
        oddFilter.add((Predicate)ManaValueParityPredicate.ODD);
    }
}

