/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.TargetPermanent;

class MutinySecondTarget
extends TargetPermanent {
    public MutinySecondTarget() {
        super((FilterPermanent)StaticFilters.FILTER_OPPONENTS_PERMANENT_CREATURE);
    }

    private MutinySecondTarget(MutinySecondTarget target) {
        super((TargetPermanent)target);
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        Set possibleTargets = super.possibleTargets(sourceControllerId, source, game);
        Permanent firstTarget = game.getPermanent(source.getFirstTarget());
        if (firstTarget == null) {
            if (possibleTargets.size() == 1) {
                possibleTargets.clear();
            }
        } else {
            possibleTargets.removeIf(id -> {
                Permanent permanent = game.getPermanent(id);
                return permanent == null || !permanent.isControlledBy(firstTarget.getControllerId());
            });
        }
        possibleTargets.removeIf(id -> firstTarget != null && firstTarget.getId().equals(id));
        return possibleTargets;
    }

    public MutinySecondTarget copy() {
        return new MutinySecondTarget(this);
    }
}

