/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class MyrBattlesphereEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("untapped Myr you control");

    public MyrBattlesphereEffect() {
        super(Outcome.Damage);
        this.staticText = "you may tap X untapped Myr you control. If you do, {this} gets +X/+0 until end of turn and deals X damage to the player or planeswalker it's attacking.";
    }

    private MyrBattlesphereEffect(MyrBattlesphereEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent myr = game.getPermanentOrLKIBattlefield(source.getSourceId());
            int tappedAmount = 0;
            TargetPermanent target = new TargetPermanent(0, 1, (FilterPermanent)filter, true);
            while (controller.canRespond()) {
                target.clearChosen();
                if (!target.canChoose(source.getControllerId(), source, game)) break;
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("UI.right.btn.text", "Myr tapping complete");
                controller.choose(this.outcome, (Target)target, source, game, options);
                if (target.getTargets().isEmpty()) break;
                UUID creature = target.getFirstTarget();
                if (creature == null) continue;
                game.getPermanent(creature).tap(source, game);
                ++tappedAmount;
            }
            if (tappedAmount > 0) {
                game.informPlayers(controller.getLogName() + " taps " + tappedAmount + " Myrs");
                game.addEffect((ContinuousEffect)new BoostSourceEffect(tappedAmount, 0, Duration.EndOfTurn), source);
                return game.damagePlayerOrPermanent(this.getTargetPointer().getFirst(game, source), tappedAmount, myr.getId(), source, game, false, true) > 0;
            }
            return true;
        }
        return false;
    }

    public MyrBattlesphereEffect copy() {
        return new MyrBattlesphereEffect(this);
    }

    static {
        filter.add((Predicate)TappedPredicate.UNTAPPED);
        filter.add((Predicate)SubType.MYR.getPredicate());
    }
}

