/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MyrWelderContinuousEffect
extends ContinuousEffectImpl {
    MyrWelderContinuousEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "{this} has all activated abilities of all cards exiled with it";
    }

    private MyrWelderContinuousEffect(MyrWelderContinuousEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent perm = game.getPermanent(source.getSourceId());
        if (perm != null) {
            for (UUID imprintedId : perm.getImprinted()) {
                Card card = game.getCard(imprintedId);
                if (card == null) continue;
                for (Ability ability : card.getAbilities(game)) {
                    if (!ability.isActivatedAbility()) continue;
                    perm.addAbility(ability, source.getId(), game, true);
                }
            }
        }
        return true;
    }

    public MyrWelderContinuousEffect copy() {
        return new MyrWelderContinuousEffect(this);
    }
}

