/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.AdventureCard;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;

class MysteriousPathlighterEffect
extends ReplacementEffectImpl {
    MysteriousPathlighterEffect() {
        super(Duration.WhileOnBattlefield, Outcome.BoostCreature);
        this.staticText = "Each creature you control that has an Adventure enters the battlefield with an additional +1/+1 counter on it";
    }

    private MysteriousPathlighterEffect(MysteriousPathlighterEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = ((EntersTheBattlefieldEvent)event).getTarget();
        return permanent instanceof PermanentCard && ((PermanentCard)permanent).getCard() instanceof AdventureCard && permanent.isControlledBy(source.getControllerId()) && permanent.isCreature(game);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent target = ((EntersTheBattlefieldEvent)event).getTarget();
        if (target != null) {
            target.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game, event.getAppliedEffects());
        }
        return false;
    }

    public MysteriousPathlighterEffect copy() {
        return new MysteriousPathlighterEffect(this);
    }
}

