/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.m.MysticReflectionGainAbilityEffect;
import mage.cards.m.MysticReflectionReplacementEffect;
import mage.cards.m.MysticReflectionWatcher;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MysticReflectionEffect
extends OneShotEffect {
    MysticReflectionEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose target nonlegendary creature. The next time one or more creatures or planeswalkers enter the battlefield this turn, they enter as copies of the chosen creature.";
    }

    private MysticReflectionEffect(MysticReflectionEffect effect) {
        super((OneShotEffect)effect);
    }

    public MysticReflectionEffect copy() {
        return new MysticReflectionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetedPermanent = game.getPermanent(source.getFirstTarget());
        game.getState().setValue("MysticReflection" + source.getSourceId().toString(), (Object)targetedPermanent);
        MysticReflectionWatcher watcher = (MysticReflectionWatcher)game.getState().getWatcher(MysticReflectionWatcher.class);
        SimpleStaticAbility staticAbilityOnCard = new SimpleStaticAbility(Zone.ALL, (Effect)new MysticReflectionReplacementEffect(watcher.getEnteredThisTurn(), source.getSourceId().toString()));
        MysticReflectionGainAbilityEffect gainAbilityEffect = new MysticReflectionGainAbilityEffect((Ability)staticAbilityOnCard);
        gainAbilityEffect.setTargetPointer((TargetPointer)new FixedTarget(targetedPermanent.getMainCard().getId(), game));
        game.addEffect((ContinuousEffect)gainAbilityEffect, source);
        return true;
    }
}

