/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.HashSet;
import java.util.Objects;
import mage.MageItem;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeGroupEvent;
import mage.watchers.Watcher;

class MysticReflectionWatcher
extends Watcher {
    private int enteredThisTurn = 0;

    MysticReflectionWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ZONE_CHANGE_GROUP) {
            return;
        }
        ZoneChangeGroupEvent zEvent = (ZoneChangeGroupEvent)event;
        if (zEvent.getToZone() != Zone.BATTLEFIELD) {
            return;
        }
        HashSet cards = new HashSet();
        cards.addAll(zEvent.getCards());
        cards.addAll(zEvent.getTokens());
        if (cards.stream().filter(Objects::nonNull).map(MageItem::getId).map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).anyMatch(p -> p.isPlaneswalker(game) || p.isCreature(game))) {
            ++this.enteredThisTurn;
        }
    }

    public void reset() {
        super.reset();
        this.enteredThisTurn = 0;
    }

    public int getEnteredThisTurn() {
        return this.enteredThisTurn;
    }
}

