/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.condition.CompoundCondition;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.ManaWasSpentCondition;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MythosOfNethroiEffect
extends OneShotEffect {
    private static final Condition condition = new CompoundCondition(new Condition[]{ManaWasSpentCondition.GREEN, ManaWasSpentCondition.WHITE});

    MythosOfNethroiEffect() {
        super(Outcome.Benefit);
        this.staticText = "Destroy target nonland permanent if it's a creature or if {G}{W} was spent to cast this spell.";
    }

    private MythosOfNethroiEffect(MythosOfNethroiEffect effect) {
        super((OneShotEffect)effect);
    }

    public MythosOfNethroiEffect copy() {
        return new MythosOfNethroiEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null || !permanent.isCreature(game) && !condition.apply(game, source)) {
            return false;
        }
        return permanent.destroy(source, game, false);
    }

    public Condition getCondition() {
        return condition;
    }
}

