/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.condition.CompoundCondition;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.ManaWasSpentCondition;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.CardUtil;

class MythosOfSnapdaxEffect
extends OneShotEffect {
    private static final Condition condition = new CompoundCondition(new Condition[]{ManaWasSpentCondition.RED, ManaWasSpentCondition.BLACK});
    private static final List<CardType> cardTypes = Arrays.asList(CardType.ARTIFACT, CardType.CREATURE, CardType.ENCHANTMENT, CardType.PLANESWALKER);

    MythosOfSnapdaxEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each player chooses an artifact, a creature, an enchantment, and a planeswalker from among the nonland permanents they control, then sacrifices the rest. If {B}{R} was spent to cast this spell, you choose the permanents for each player instead.";
    }

    private MythosOfSnapdaxEffect(MythosOfSnapdaxEffect effect) {
        super((OneShotEffect)effect);
    }

    public MythosOfSnapdaxEffect copy() {
        return new MythosOfSnapdaxEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        boolean conditionMet = condition.apply(game, source);
        List playerList = game.getState().getPlayersInRange(source.getControllerId(), game).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        HashSet<UUID> toKeep = new HashSet<UUID>();
        for (Player player : playerList) {
            for (CardType cardType : cardTypes) {
                String message = CardUtil.addArticle((String)cardType.toString());
                message = message + (conditionMet && player != controller ? " controlled by " + player.getName() : " you control");
                FilterNonlandPermanent filter = new FilterNonlandPermanent(message);
                filter.add((Predicate)cardType.getPredicate());
                filter.add((Predicate)new ControllerIdPredicate(player.getId()));
                if (game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game) == 0) continue;
                TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
                target.withNotTarget(true);
                if (conditionMet) {
                    controller.choose(this.outcome, (Target)target, source, game);
                } else {
                    player.choose(this.outcome, (Target)target, source, game);
                }
                toKeep.add(target.getFirstTarget());
            }
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_NON_LAND, source.getControllerId(), game)) {
            if (permanent == null || toKeep.contains(permanent.getId())) continue;
            permanent.sacrifice(source, game);
        }
        return true;
    }

    public Condition getCondition() {
        return condition;
    }
}

