/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.events.NumberOfTriggersEvent;

class NabanDeanOfIterationEffect
extends ReplacementEffectImpl {
    NabanDeanOfIterationEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if a Wizard you control entering causes a triggered ability of a permanent you control to trigger, that ability triggers an additional time";
    }

    private NabanDeanOfIterationEffect(NabanDeanOfIterationEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public NabanDeanOfIterationEffect copy() {
        return new NabanDeanOfIterationEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.NUMBER_OF_TRIGGERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event instanceof NumberOfTriggersEvent) {
            EntersTheBattlefieldEvent entersTheBattlefieldEvent;
            GameEvent sourceEvent;
            NumberOfTriggersEvent numberOfTriggersEvent = (NumberOfTriggersEvent)event;
            if (source.isControlledBy(event.getPlayerId()) && (sourceEvent = numberOfTriggersEvent.getSourceEvent()) != null && sourceEvent.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD && sourceEvent instanceof EntersTheBattlefieldEvent && (entersTheBattlefieldEvent = (EntersTheBattlefieldEvent)sourceEvent).getTarget().hasSubtype(SubType.WIZARD, game)) {
                return game.getPermanent(numberOfTriggersEvent.getSourceId()) != null;
            }
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(event.getAmount() + 1);
        return false;
    }
}

