/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.PermanentReferenceInCollectionPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.KorWarriorToken;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class NahiriHeirOfTheAncientsEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.EQUIPMENT);

    NahiriHeirOfTheAncientsEffect() {
        super(Outcome.Benefit);
        this.staticText = "Create a 1/1 white Kor Warrior creature token. You may attach an Equipment you control to it.";
    }

    private NahiriHeirOfTheAncientsEffect(NahiriHeirOfTheAncientsEffect effect) {
        super((OneShotEffect)effect);
    }

    public NahiriHeirOfTheAncientsEffect copy() {
        return new NahiriHeirOfTheAncientsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        KorWarriorToken token = new KorWarriorToken();
        token.putOntoBattlefield(1, game, source, source.getControllerId());
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        List tokens = token.getLastAddedTokenIds().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        int equipCount = game.getBattlefield().count(filter, source.getControllerId(), source, game);
        if (tokens.isEmpty() || equipCount == 0 || !player.chooseUse(this.outcome, "Attach an equipment to the token?", source, game)) {
            return true;
        }
        Permanent tokenCreature = (Permanent)tokens.get(0);
        if (tokens.size() > 1) {
            FilterPermanent tokenFilter = new FilterPermanent("token");
            tokenFilter.add((Predicate)new PermanentReferenceInCollectionPredicate(tokens, game));
            TargetPermanent target = new TargetPermanent(tokenFilter);
            target.withNotTarget(true);
            player.choose(this.outcome, (Target)target, source, game);
            tokenCreature = game.getPermanent(target.getFirstTarget());
        }
        TargetPermanent target = new TargetPermanent(filter);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        tokenCreature.addAttachment(target.getFirstTarget(), source, game);
        return true;
    }
}

