/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfYourNextUpkeepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.n.NahirisResolveReturnEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class NahirisResolveExileEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent("nontoken artifacts and/or creatures you control");

    NahirisResolveExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile any number of nontoken artifacts and/or creatures you control. Return those cards to the battlefield under their owner's control at the beginning of your next upkeep";
    }

    private NahirisResolveExileEffect(NahirisResolveExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public NahirisResolveExileEffect copy() {
        return new NahirisResolveExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, filter, true);
        player.choose(this.outcome, (Target)target, source, game);
        CardsImpl cards = new CardsImpl((Collection)target.getTargets());
        player.moveCardsToExile(cards.getCards(game), source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfYourNextUpkeepDelayedTriggeredAbility((Effect)new NahirisResolveReturnEffect().setTargetPointer((TargetPointer)new FixedTargets((Cards)cards, game))), source);
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.ARTIFACT.getPredicate(), (Predicate)CardType.CREATURE.getPredicate()));
        filter.add((Predicate)TokenPredicate.FALSE);
    }
}

