/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class NantukoCultivatorEffect
extends OneShotEffect {
    NantukoCultivatorEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "you may discard any number of land cards. Put that many +1/+1 counters on {this} and draw that many cards.";
    }

    private NantukoCultivatorEffect(NantukoCultivatorEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getHand().count((FilterCard)StaticFilters.FILTER_CARD_LAND, game) < 1) {
            return false;
        }
        TargetCardInHand toDiscard = new TargetCardInHand(0, Integer.MAX_VALUE, (FilterCard)StaticFilters.FILTER_CARD_LAND);
        player.chooseTarget(Outcome.AIDontUseIt, (Target)toDiscard, source, game);
        int count = player.discard((Cards)new CardsImpl((Collection)toDiscard.getTargets()), false, source, game).size();
        if (count < 1) {
            return false;
        }
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null) {
            permanent.addCounters(CounterType.P1P1.createInstance(count), source.getControllerId(), source, game);
        }
        player.drawCards(count, source, game);
        return true;
    }

    public NantukoCultivatorEffect copy() {
        return new NantukoCultivatorEffect(this);
    }
}

