/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class NarsetTranscendentEffect1
extends OneShotEffect {
    public NarsetTranscendentEffect1() {
        super(Outcome.DrawCard);
        this.staticText = "Look at the top card of your library. If it's a noncreature, nonland card, you may reveal it and put it into your hand";
    }

    private NarsetTranscendentEffect1(NarsetTranscendentEffect1 effect) {
        super((OneShotEffect)effect);
    }

    public NarsetTranscendentEffect1 copy() {
        return new NarsetTranscendentEffect1(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (sourceObject != null && controller != null && controller.getLibrary().hasCards() && (card = controller.getLibrary().getFromTop(game)) != null) {
            CardsImpl cards = new CardsImpl();
            cards.add(card);
            controller.lookAtCards(sourceObject.getIdName(), (Cards)cards, game);
            if (!card.isCreature(game) && !card.isLand(game) && controller.chooseUse(this.outcome, "Reveal " + card.getLogName() + " and put it into your hand?", source, game)) {
                controller.moveCards(card, Zone.HAND, source, game);
                controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
            }
            return true;
        }
        return false;
    }
}

