/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.ReboundAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class NarsetTranscendentGainReboundEffect
extends ContinuousEffectImpl {
    NarsetTranscendentGainReboundEffect() {
        super(Duration.Custom, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "it gains rebound";
    }

    private NarsetTranscendentGainReboundEffect(NarsetTranscendentGainReboundEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public NarsetTranscendentGainReboundEffect copy() {
        return new NarsetTranscendentGainReboundEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
            if (spell != null) {
                Card card = spell.getCard();
                if (card != null) {
                    this.addReboundAbility(card, game);
                }
            } else {
                this.discard();
            }
            return true;
        }
        return false;
    }

    private void addReboundAbility(Card card, Game game) {
        boolean found = false;
        for (Ability ability : card.getAbilities(game)) {
            if (!(ability instanceof ReboundAbility)) continue;
            found = true;
            break;
        }
        if (!found) {
            ReboundAbility ability = new ReboundAbility();
            game.getState().addOtherAbility(card, (Ability)ability);
        }
    }
}

