/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Collection;
import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.Ability;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.common.asthought.CanPlayCardControllerEffect;
import mage.cards.Card;
import mage.cards.n.NashiMoonSagesScionWatcher;
import mage.constants.Duration;
import mage.game.Game;
import mage.players.Player;

class NashiMoonSagesScionPlayEffect
extends CanPlayCardControllerEffect {
    NashiMoonSagesScionPlayEffect(Game game, Card card) {
        super(game, card.getMainCard().getId(), card.getZoneChangeCounter(game), false, Duration.EndOfTurn);
    }

    private NashiMoonSagesScionPlayEffect(NashiMoonSagesScionPlayEffect effect) {
        super((CanPlayCardControllerEffect)effect);
    }

    public NashiMoonSagesScionPlayEffect copy() {
        return new NashiMoonSagesScionPlayEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (!super.applies(objectId, source, affectedControllerId, game) || !NashiMoonSagesScionWatcher.checkCard(game, source, this.mor)) {
            return false;
        }
        Card cardToCheck = this.mor.getCard(game);
        if (cardToCheck.isLand(game)) {
            return true;
        }
        Player controller = game.getPlayer(source.getControllerId());
        PayLifeCost lifeCost = new PayLifeCost(cardToCheck.getSpellAbility().getManaCosts().manaValue());
        CostsImpl newCosts = new CostsImpl();
        newCosts.add((Object)lifeCost);
        newCosts.addAll((Collection)cardToCheck.getSpellAbility().getCosts());
        controller.setCastSourceIdWithAlternateMana(cardToCheck.getId(), null, (Costs)newCosts, MageIdentifier.NashiMoonSagesScionAlternateCast);
        return true;
    }
}

