/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledLandPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.players.PlayerList;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetControlledPermanent;

class NaturalBalanceEffect
extends OneShotEffect {
    NaturalBalanceEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Each player who controls six or more lands chooses five lands they control and sacrifices the rest. Each player who controls four or fewer lands may search their library for up to X basic land cards and put them onto the battlefield, where X is five minus the number of lands they control. Then each player who searched their library this way shuffles.";
    }

    private NaturalBalanceEffect(NaturalBalanceEffect effect) {
        super((OneShotEffect)effect);
    }

    public NaturalBalanceEffect copy() {
        return new NaturalBalanceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            PlayerList players = game.getState().getPlayersInRange(controller.getId(), game);
            for (UUID playerId : players) {
                TargetControlledPermanent target;
                int landCount;
                Player player = game.getPlayer(playerId);
                if (player == null || (landCount = game.getBattlefield().countAll((FilterPermanent)new FilterControlledLandPermanent(), player.getId(), game)) <= 5 || !(target = new TargetControlledPermanent(5, 5, (FilterControlledPermanent)new FilterControlledLandPermanent("lands to keep"), true)).choose(Outcome.Sacrifice, player.getId(), source.getSourceId(), source, game)) continue;
                for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)new FilterLandPermanent(), player.getId(), game)) {
                    if (target.getTargets().contains(permanent.getId())) continue;
                    permanent.sacrifice(source, game);
                }
            }
            ArrayList<Player> toShuffle = new ArrayList<Player>();
            for (UUID playerId : players) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                int landCount = game.getBattlefield().countAll((FilterPermanent)new FilterControlledLandPermanent(), player.getId(), game);
                int amount = 5 - landCount;
                if (landCount >= 5 || !player.chooseUse(this.outcome, "Search your library for up to " + amount + " basic land cards and put them onto the battlefield?", source, game)) continue;
                TargetCardInLibrary target = new TargetCardInLibrary(0, amount, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND);
                if (player.searchLibrary(target, source, game)) {
                    player.moveCards(new CardsImpl((Collection)target.getTargets()).getCards(game), Zone.BATTLEFIELD, source, game);
                }
                toShuffle.add(player);
            }
            for (Player player : toShuffle) {
                player.shuffleLibrary(source, game);
            }
            return true;
        }
        return false;
    }
}

