/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.CardType;
import mage.game.Game;
import mage.game.permanent.Permanent;

enum NaturesEmbraceCondition implements Condition
{
    CREATURE(CardType.CREATURE),
    LAND(CardType.LAND);

    private final CardType cardType;

    private NaturesEmbraceCondition(CardType cardType) {
        this.cardType = cardType;
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        Permanent attached = game.getPermanent(permanent.getAttachedTo());
        return attached != null && attached.getCardType(game).contains(this.cardType);
    }
}

