/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.game.Game;
import mage.players.Player;

class NaturesResurgenceEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCreatureCard("creature");

    public NaturesResurgenceEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Each player draws a card for each creature card in their graveyard";
    }

    private NaturesResurgenceEffect(NaturesResurgenceEffect effect) {
        super((OneShotEffect)effect);
    }

    public NaturesResurgenceEffect copy() {
        return new NaturesResurgenceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player sourcePlayer = game.getPlayer(source.getControllerId());
        if (sourcePlayer != null) {
            for (UUID playerId : game.getState().getPlayersInRange(sourcePlayer.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                int amount = player.getGraveyard().count(filter, game);
                player.drawCards(amount, source, game);
            }
        }
        return true;
    }
}

