/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInExile;
import mage.util.CardUtil;

class NautiloidShipEffect
extends OneShotEffect {
    NautiloidShipEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may put a creature card exiled with {this} onto the battlefield under your control";
    }

    private NautiloidShipEffect(NautiloidShipEffect effect) {
        super((OneShotEffect)effect);
    }

    public NautiloidShipEffect copy() {
        return new NautiloidShipEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInExile target = new TargetCardInExile(0, 1, (FilterCard)StaticFilters.FILTER_CARD_CREATURE, CardUtil.getExileZoneId((Game)game, (Ability)source));
        player.choose(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        return card != null && player.moveCards(card, Zone.BATTLEFIELD, source, game);
    }
}

