/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.condition.common.SpellMasteryCondition;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class NecromanticSummoningReplacementEffect
extends ReplacementEffectImpl {
    NecromanticSummoningReplacementEffect() {
        super(Duration.EndOfStep, Outcome.BoostCreature);
    }

    private NecromanticSummoningReplacementEffect(NecromanticSummoningReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getTargetId().equals(this.getTargetPointer().getFirst(game, source))) {
            return SpellMasteryCondition.instance.apply(game, source);
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        if (creature != null) {
            creature.addCounters(CounterType.P1P1.createInstance(2), source.getControllerId(), source, game, event.getAppliedEffects());
            this.discard();
        }
        return false;
    }

    public NecromanticSummoningReplacementEffect copy() {
        return new NecromanticSummoningReplacementEffect(this);
    }
}

