/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostAdjuster;
import mage.abilities.costs.common.ExileFromGraveCost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.dynamicvalue.common.SignInversionDynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.keyword.DelveAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.n.NecropolisFiendCostAdjuster;
import mage.cards.n.NecropolisFiendTargetAdjuster;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.common.TargetCreaturePermanent;
import mage.target.targetadjustment.TargetAdjuster;

public final class NecropolisFiend
extends CardImpl {
    public NecropolisFiend(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{7}{B}{B}");
        this.subtype.add((Object)SubType.DEMON);
        this.power = new MageInt(4);
        this.toughness = new MageInt(5);
        this.addAbility((Ability)new DelveAbility(false));
        this.addAbility((Ability)FlyingAbility.getInstance());
        SignInversionDynamicValue xValue = new SignInversionDynamicValue((DynamicValue)GetXValue.instance);
        BoostTargetEffect effect = new BoostTargetEffect((DynamicValue)xValue, (DynamicValue)xValue, Duration.EndOfTurn);
        effect.setText("Target creature gets -X/-X until end of turn");
        SimpleActivatedAbility ability = new SimpleActivatedAbility(Zone.BATTLEFIELD, (Effect)effect, (Cost)new ManaCostsImpl("{X}"));
        ability.addCost((Cost)new TapSourceCost());
        ability.addTarget((Target)new TargetCreaturePermanent());
        ability.addCost((Cost)new ExileFromGraveCost(new TargetCardInYourGraveyard(1, 1, StaticFilters.FILTER_CARDS_FROM_YOUR_GRAVEYARD), "Exile X cards from your graveyard"));
        ability.setTargetAdjuster((TargetAdjuster)NecropolisFiendTargetAdjuster.instance);
        ability.setCostAdjuster((CostAdjuster)NecropolisFiendCostAdjuster.instance);
        this.addAbility((Ability)ability);
    }

    private NecropolisFiend(NecropolisFiend card) {
        super((CardImpl)card);
    }

    public NecropolisFiend copy() {
        return new NecropolisFiend(this);
    }
}

