/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class NecropotenceEffect
extends OneShotEffect {
    NecropotenceEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile the top card of your library face down. Put that card into your hand at the beginning of your next end step";
    }

    private NecropotenceEffect(NecropotenceEffect effect) {
        super((OneShotEffect)effect);
    }

    public NecropotenceEffect copy() {
        return new NecropotenceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card = controller.getLibrary().getFromTop(game);
            if (card != null && controller.moveCardsToExile(card, source, game, false, CardUtil.getCardExileZoneId((Game)game, (Ability)source), CardUtil.createObjectRelatedWindowTitle((Ability)source, (Game)game, null))) {
                card.setFaceDown(true, game);
                ReturnToHandTargetEffect returnToHandEffect = new ReturnToHandTargetEffect();
                returnToHandEffect.setText("put that face down card into your hand");
                returnToHandEffect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)returnToHandEffect, TargetController.YOU), source);
                return true;
            }
            return true;
        }
        return false;
    }
}

