/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class NeeraWildMageEffect
extends OneShotEffect {
    NeeraWildMageEffect() {
        super(Outcome.Neutral);
        this.staticText = "you may put it on the bottom of its owner's library. If you do, reveal cards from the top of your library until you reveal a nonland card. You may cast that card without paying its mana cost. Then put all revealed cards not cast this way on the bottom of your library in a random order";
    }

    private NeeraWildMageEffect(NeeraWildMageEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell == null) {
            return false;
        }
        Player spellController = game.getPlayer(spell.getControllerId());
        if (spellController == null) {
            return false;
        }
        if (!spellController.putCardsOnBottomOfLibrary((Card)spell, game, source)) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || controller.getLibrary() == null || !controller.getLibrary().hasCards()) {
            return false;
        }
        CardsImpl toReveal = new CardsImpl();
        Card eligibleCard = null;
        for (Card card : controller.getLibrary().getCards(game)) {
            toReveal.add(card);
            if (card.isLand(game)) continue;
            eligibleCard = card;
            break;
        }
        controller.revealCards(source, (Cards)toReveal, game);
        if (eligibleCard != null && controller.chooseUse(Outcome.PlayForFree, "Cast " + eligibleCard.getLogName() + " without paying its mana cost?", source, game)) {
            game.getState().setValue("PlayFromNotOwnHandZone" + eligibleCard.getId(), (Object)Boolean.TRUE);
            boolean cardWasCast = controller.cast(controller.chooseAbilityForCast(eligibleCard, game, true), game, true, new ApprovingObject(source, game));
            game.getState().setValue("PlayFromNotOwnHandZone" + eligibleCard.getId(), null);
            if (cardWasCast) {
                toReveal.remove(eligibleCard);
            }
        }
        controller.putCardsOnBottomOfLibrary((Cards)toReveal, game, source, false);
        return true;
    }

    public NeeraWildMageEffect copy() {
        return new NeeraWildMageEffect(this);
    }
}

