/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.awt.Color;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.hint.HintUtils;
import mage.constants.CardType;
import mage.filter.FilterCard;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.target.common.TargetCardInYourGraveyard;
import mage.util.CardUtil;

class NethergoyfTarget
extends TargetCardInYourGraveyard {
    private static final FilterCard filter = new FilterCard("other cards from your graveyard with four or more card types among them");

    NethergoyfTarget() {
        super(1, Integer.MAX_VALUE, filter, true);
    }

    private NethergoyfTarget(NethergoyfTarget target) {
        super((TargetCardInYourGraveyard)target);
    }

    public NethergoyfTarget copy() {
        return new NethergoyfTarget(this);
    }

    public boolean isChosen(Game game) {
        return super.isChosen(game) && NethergoyfTarget.metCondition(this.getTargets(), game);
    }

    public String getMessage(Game game) {
        String text = "Select " + CardUtil.addArticle((String)this.targetName);
        Set<CardType> types = NethergoyfTarget.typesAmongSelection(this.getTargets(), game);
        text = text + " (selected " + this.getTargets().size() + " cards; card types: ";
        text = text + HintUtils.prepareText((String)(types.size() + " of 4"), (Color)(types.size() >= 4 ? Color.GREEN : Color.RED));
        String info = types.stream().map(CardType::toString).collect(Collectors.joining(", "));
        if (!info.isEmpty()) {
            text = text + " [" + info + "]";
        }
        text = text + ")";
        return text;
    }

    public boolean canChoose(UUID sourceControllerId, Ability source, Game game) {
        if (!super.canChoose(sourceControllerId, source, game)) {
            return false;
        }
        HashSet<UUID> idsToCheck = new HashSet<UUID>();
        idsToCheck.addAll(this.getTargets());
        idsToCheck.addAll(this.possibleTargets(sourceControllerId, source, game));
        return NethergoyfTarget.metCondition(idsToCheck, game);
    }

    private static Set<CardType> typesAmongSelection(Collection<UUID> cardsIds, Game game) {
        return cardsIds.stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).flatMap(c -> c.getCardType(game).stream()).collect(Collectors.toSet());
    }

    private static boolean metCondition(Collection<UUID> cardsIds, Game game) {
        return NethergoyfTarget.typesAmongSelection(cardsIds, game).size() >= 4;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

