/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class NeurokFamiliarEffect
extends OneShotEffect {
    NeurokFamiliarEffect() {
        super(Outcome.DrawCard);
        this.staticText = "reveal the top card of your library. If it's an artifact card, put it into your hand. Otherwise, put it into your graveyard.";
    }

    private NeurokFamiliarEffect(NeurokFamiliarEffect effect) {
        super((OneShotEffect)effect);
    }

    public NeurokFamiliarEffect copy() {
        return new NeurokFamiliarEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        if (controller.getLibrary().hasCards() && (card = controller.getLibrary().getFromTop(game)) != null) {
            CardsImpl cards = new CardsImpl(card);
            controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
            if (card.isArtifact(game)) {
                controller.moveCards(card, Zone.HAND, source, game);
            } else {
                controller.moveCards(card, Zone.GRAVEYARD, source, game);
            }
        }
        return true;
    }
}

