/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.ArrayList;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class NeverwinterHydraEffect
extends OneShotEffect {
    NeverwinterHydraEffect() {
        super(Outcome.Benefit);
        this.staticText = "roll X d6. It enters with a number of +1/+1 counters on it equal to the total of those results";
    }

    private NeverwinterHydraEffect(NeverwinterHydraEffect effect) {
        super((OneShotEffect)effect);
    }

    public NeverwinterHydraEffect copy() {
        return new NeverwinterHydraEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        Player player = game.getPlayer(source.getControllerId());
        if (permanent != null && player != null) {
            int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
            if (xValue > 0) {
                int amount = player.rollDice(this.outcome, source, game, 6, xValue, 0).stream().mapToInt(x -> x).sum();
                ArrayList appliedEffects = (ArrayList)this.getValue("appliedEffects");
                permanent.addCounters(CounterType.P1P1.createInstance(amount), source.getControllerId(), source, game, (List)appliedEffects);
            }
            return true;
        }
        return false;
    }
}

