/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.watchers.Watcher;

class NeyaliSunsVanguardWatcher
extends Watcher {
    private final Set<UUID> set = new HashSet<UUID>();

    NeyaliSunsVanguardWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ATTACKER_DECLARED) {
            return;
        }
        Permanent permanent = game.getPermanent(event.getSourceId());
        if (permanent instanceof PermanentToken) {
            this.set.add(permanent.getControllerId());
        }
    }

    public void reset() {
        super.reset();
        this.set.clear();
    }

    static boolean checkPlayer(Game game, Ability source) {
        return ((NeyaliSunsVanguardWatcher)game.getState().getWatcher(NeyaliSunsVanguardWatcher.class)).set.contains(source.getControllerId());
    }
}

