/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.ExploredEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class NicanzilCurrentConductorTriggeredAbility
extends TriggeredAbilityImpl {
    private final boolean isLand;

    NicanzilCurrentConductorTriggeredAbility(Effect effect, boolean isLand) {
        super(Zone.BATTLEFIELD, effect);
        this.isLand = isLand;
        this.setTriggerPhrase("Whenever a creature you control explores a " + (isLand ? "" : "non") + "land card, ");
    }

    private NicanzilCurrentConductorTriggeredAbility(NicanzilCurrentConductorTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
        this.isLand = ability.isLand;
    }

    public NicanzilCurrentConductorTriggeredAbility copy() {
        return new NicanzilCurrentConductorTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.EXPLORED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ExploredEvent eEvent = (ExploredEvent)event;
        Permanent permanent = game.getPermanent(eEvent.getTargetId());
        return permanent != null && permanent.isCreature(game) && permanent.isControlledBy(this.getControllerId()) && eEvent.getCard() != null && eEvent.getCard().isLand(game) == this.isLand;
    }
}

