/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterPlaneswalkerPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class NicolBolasDragonGodGainAbilitiesEffect
extends ContinuousEffectImpl {
    private static final FilterPermanent filter = new FilterPlaneswalkerPermanent();

    NicolBolasDragonGodGainAbilitiesEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "{this} has all loyalty abilities of all other planeswalkers on the battlefield.";
    }

    private NicolBolasDragonGodGainAbilitiesEffect(NicolBolasDragonGodGainAbilitiesEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent perm = game.getPermanent(source.getSourceId());
        if (perm == null) {
            return true;
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            for (Ability ability : permanent.getAbilities()) {
                if (!(ability instanceof LoyaltyAbility)) continue;
                perm.addAbility(ability, source.getSourceId(), game, true);
            }
        }
        return true;
    }

    public NicolBolasDragonGodGainAbilitiesEffect copy() {
        return new NicolBolasDragonGodGainAbilitiesEffect(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

