/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Library;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class NicolBolasGodPharaohPlusTwoEffect
extends OneShotEffect {
    NicolBolasGodPharaohPlusTwoEffect() {
        super(Outcome.Detriment);
        this.staticText = "Target opponent exiles cards from the top of their library until they exile a nonland card. Until end of turn, you may cast that card without paying its mana cost";
    }

    private NicolBolasGodPharaohPlusTwoEffect(NicolBolasGodPharaohPlusTwoEffect effect) {
        super((OneShotEffect)effect);
    }

    public NicolBolasGodPharaohPlusTwoEffect copy() {
        return new NicolBolasGodPharaohPlusTwoEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (opponent == null) {
            return false;
        }
        Library library = opponent.getLibrary();
        while ((card = library.getFromTop(game)) != null && opponent.moveCards(card, Zone.EXILED, source, game)) {
            if (!card.isLand(game)) {
                PlayFromNotOwnHandZoneTargetEffect effect = new PlayFromNotOwnHandZoneTargetEffect(Zone.EXILED, TargetController.YOU, Duration.EndOfTurn, true);
                effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
                game.addEffect((ContinuousEffect)effect, source);
                break;
            }
            if (library.hasCards()) continue;
        }
        return true;
    }
}

