/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileAllEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.players.Player;

class NightmareUnmakingEffect
extends OneShotEffect {
    private final ComparisonType comparisonType;

    NightmareUnmakingEffect(boolean lessThan) {
        super(Outcome.Benefit);
        this.comparisonType = lessThan ? ComparisonType.FEWER_THAN : ComparisonType.MORE_THAN;
        this.staticText = "exile each creature with power " + (lessThan ? "less" : "greater") + " than the number of cards in your hand";
    }

    private NightmareUnmakingEffect(NightmareUnmakingEffect effect) {
        super((OneShotEffect)effect);
        this.comparisonType = effect.comparisonType;
    }

    public NightmareUnmakingEffect copy() {
        return new NightmareUnmakingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add((Predicate)new PowerPredicate(this.comparisonType, player.getHand().size()));
        return new ExileAllEffect((FilterPermanent)filter).apply(game, source);
    }
}

