/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Collection;
import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class NightshadeAssassinEffect
extends OneShotEffect {
    NightshadeAssassinEffect() {
        super(Outcome.UnboostCreature);
        this.staticText = "you may reveal X black cards in your hand. If you do, target creature gets -X/-X until end of turn";
    }

    private NightshadeAssassinEffect(NightshadeAssassinEffect effect) {
        super((OneShotEffect)effect);
    }

    public NightshadeAssassinEffect copy() {
        return new NightshadeAssassinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TargetCardInHand target;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        FilterCard filter = new FilterCard();
        filter.add((Predicate)new ColorPredicate(ObjectColor.BLACK));
        int blackCards = controller.getHand().count(filter, source.getControllerId(), source, game);
        int cardsToReveal = controller.getAmount(0, blackCards, "Reveal how many black cards?", source, game);
        game.informPlayers(controller.getLogName() + " chooses to reveal " + cardsToReveal + " black cards.");
        if (cardsToReveal > 0 && controller.choose(Outcome.Benefit, (Target)(target = new TargetCardInHand(cardsToReveal, cardsToReveal, filter)), source, game)) {
            controller.revealCards(sourceObject.getIdName(), (Cards)new CardsImpl((Collection)target.getTargets()), game);
            int unboost = target.getTargets().size() * -1;
            BoostTargetEffect effect = new BoostTargetEffect(unboost, unboost, Duration.EndOfTurn);
            effect.setTargetPointer(this.getTargetPointer().copy());
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

