/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;

class NikoArisDamageTriggeredAbility
extends DelayedTriggeredAbility {
    NikoArisDamageTriggeredAbility() {
        super((Effect)new ReturnToHandTargetEffect(), Duration.EndOfTurn, false);
    }

    private NikoArisDamageTriggeredAbility(NikoArisDamageTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public NikoArisDamageTriggeredAbility copy() {
        return new NikoArisDamageTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGED_PLAYER: 
            case DAMAGED_PERMANENT: {
                return true;
            }
        }
        return false;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return this.getEffects().stream().filter(Objects::nonNull).map(Effect::getTargetPointer).map(targetPointer -> targetPointer.getFirst(game, (Ability)this)).anyMatch(event.getSourceId()::equals);
    }

    public String getRule() {
        return "Whenever that creature deals damage this turn, return it to its owner's hand.";
    }
}

