/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class NikyaOfTheOldWaysCantCastEffect
extends ContinuousRuleModifyingEffectImpl {
    NikyaOfTheOldWaysCantCastEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "You can't cast noncreature spells";
    }

    private NikyaOfTheOldWaysCantCastEffect(NikyaOfTheOldWaysCantCastEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public NikyaOfTheOldWaysCantCastEffect copy() {
        return new NikyaOfTheOldWaysCantCastEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getPlayerId().equals(source.getControllerId())) {
            Card card = game.getCard(event.getSourceId());
            return card != null && !card.isCreature(game);
        }
        return false;
    }
}

