/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.Mana;
import mage.abilities.effects.mana.BasicManaEffect;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.TriggeredManaAbility;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;

class NirkanaRevenantTriggeredAbility
extends TriggeredManaAbility {
    NirkanaRevenantTriggeredAbility() {
        super(Zone.BATTLEFIELD, (ManaEffect)new BasicManaEffect(Mana.BlackMana((int)1)), false);
    }

    private NirkanaRevenantTriggeredAbility(NirkanaRevenantTriggeredAbility ability) {
        super((TriggeredManaAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        Permanent permanent = ((TappedForManaEvent)event).getPermanent();
        return permanent != null && permanent.hasSubtype(SubType.SWAMP, game);
    }

    public NirkanaRevenantTriggeredAbility copy() {
        return new NirkanaRevenantTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever you tap a Swamp for mana, add an additional {B}.";
    }
}

