/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Objects;
import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.token.PhyrexianHorrorGreenToken;

class NissaAscendedAnimistEffect
extends OneShotEffect {
    NissaAscendedAnimistEffect() {
        super(Outcome.Benefit);
        this.staticText = "create an X/X green Phyrexian Horror creature token, where X is {this}'s loyalty";
    }

    private NissaAscendedAnimistEffect(NissaAscendedAnimistEffect effect) {
        super((OneShotEffect)effect);
    }

    public NissaAscendedAnimistEffect copy() {
        return new NissaAscendedAnimistEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int loyalty = Optional.ofNullable(source.getSourcePermanentOrLKI(game)).filter(Objects::nonNull).map(permanent -> permanent.getCounters(game)).map(counters -> counters.getCount(CounterType.LOYALTY)).orElse(0);
        return new PhyrexianHorrorGreenToken(loyalty).putOntoBattlefield(1, game, source);
    }
}

