/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.players.Player;

class NissaRevaneGainLifeEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent(SubType.ELF);

    public NissaRevaneGainLifeEffect() {
        super(Outcome.GainLife);
        this.staticText = "You gain 2 life for each Elf you control";
    }

    private NissaRevaneGainLifeEffect(NissaRevaneGainLifeEffect effect) {
        super((OneShotEffect)effect);
    }

    public NissaRevaneGainLifeEffect copy() {
        return new NissaRevaneGainLifeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        int life = 2 * game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game);
        if (player != null) {
            player.gainLife(life, game, source);
        }
        return true;
    }
}

