/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class NissasRevelationEffect
extends OneShotEffect {
    NissasRevelationEffect() {
        super(Outcome.DrawCard);
        this.staticText = ", then reveal the top card of your library. If it's a creature card, you draw cards equal to its power and you gain life equal to its toughness";
    }

    private NissasRevelationEffect(NissasRevelationEffect effect) {
        super((OneShotEffect)effect);
    }

    public NissasRevelationEffect copy() {
        return new NissasRevelationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            Card card = controller.getLibrary().getFromTop(game);
            if (card != null) {
                CardsImpl cards = new CardsImpl();
                cards.add(card);
                controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
                if (card.isCreature(game)) {
                    controller.drawCards(card.getPower().getValue(), source, game);
                    controller.gainLife(card.getToughness().getValue(), game, source);
                }
            }
            return true;
        }
        return false;
    }
}

